#pragma once

#include "BowerShader.h"

using namespace std;
using namespace DirectX;

//A complex shader used to create the water simulation effect
class WaterShader : public BowerShader
{
	public:
		struct WaterPixelBufferType
		{
			float moveFactor;	//Factor to move the water by - should be increased by the speed multipled by delta time
			XMFLOAT3 sunColour;	//Colour of the sun
		};

		struct WaterVertexBufferType
		{
			XMFLOAT4 cameraPosition;
			XMMATRIX reflectionMatrix;	//Matrix of the reflection position
			XMFLOAT3 sunPosition;
			float padding;
		};

		WaterShader(ID3D11Device* device, HWND hwnd);
		~WaterShader();

		void setShaderParameters(ID3D11DeviceContext* deviceContext, const XMMATRIX &world, const XMMATRIX &view, const XMMATRIX &projection, const XMMATRIX &reflection, ID3D11ShaderResourceView* reflectionTexture, ID3D11ShaderResourceView* refractionTexture, ID3D11ShaderResourceView* dudvTexture, ID3D11ShaderResourceView* normalTexture, XMFLOAT3 cameraPosition, float deltaTime);

	private:
		void initShader(const wchar_t* vs, const wchar_t* ps);

	private:
		ID3D11Buffer * matrixBuffer;
		ID3D11Buffer* waterPixelBuffer;
		ID3D11Buffer* waterVertexBuffer;
		ID3D11SamplerState* sampleState;
		float _MoveFactor;
		float _WaveSpeed;	
};

